<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Variables-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwvars="urn:WebWorks-Variables-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwvars wwfilesext wwmode wwfiles wwdoc wwproject wwpage wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:key name="wwvars-groups-by-groupid" match="wwvars:Group" use="@groupID" />
 <xsl:key name="wwvars-documents-by-documentid" match="wwvars:Document" use="@documentID" />
 <xsl:key name="wwvars-variables-by-name" match="wwvars:Variable" use="@name" />


 <xsl:template name="Variables-Globals-Split">
  <xsl:param name="ParamProjectVariables" />
  <xsl:param name="ParamSplit" />

  <!-- Access group variables -->
  <!--                        -->
  <xsl:for-each select="$ParamProjectVariables[1]">
   <xsl:variable name="VarVariablesGroup" select="key('wwvars-groups-by-groupid', $ParamSplit/@groupID)[1]" />

   <!-- Determine document position -->
   <!--                             -->
   <xsl:variable name="VarDocumentPosition" select="key('wwvars-documents-by-documentid', $ParamSplit/@documentID)/@position" />

   <!-- Emit following variables first and then preceeding variables -->
   <!-- This will mimic the Publisher 2003 behavior for globals      -->
   <!--                                                              -->
   <!-- Record preceeding variables -->
   <!--                             -->
   <xsl:variable name="VarVariablesAsXML">
    <!-- Following splits -->
    <!--                  -->
    <xsl:for-each select="$VarVariablesGroup/wwvars:Document[@position = $VarDocumentPosition]">
     <xsl:variable name="VarVariablesDocument" select="." />

     <xsl:for-each select="$VarVariablesDocument/wwvars:Split[@position &gt; $ParamSplit/@position]">
      <xsl:variable name="VarVariablesSplit" select="." />

      <!-- Copy all variables -->
      <!--                    -->
      <xsl:copy-of select="$VarVariablesSplit/wwvars:Variable" />
     </xsl:for-each>
    </xsl:for-each>

    <!-- Following documents -->
    <!--                     -->
    <xsl:for-each select="$VarVariablesGroup/wwvars:Document[@position &gt; $VarDocumentPosition]">
     <xsl:variable name="VarVariablesDocument" select="." />

     <xsl:for-each select="$VarVariablesDocument/wwvars:Split">
      <xsl:variable name="VarVariablesSplit" select="." />

      <!-- Copy all variables -->
      <!--                    -->
      <xsl:copy-of select="$VarVariablesSplit/wwvars:Variable" />
     </xsl:for-each>
    </xsl:for-each>

    <!-- Preceding documents -->
    <!--                     -->
    <xsl:for-each select="$VarVariablesGroup/wwvars:Document[@position &lt; $VarDocumentPosition]">
     <xsl:variable name="VarVariablesDocument" select="." />

     <xsl:for-each select="$VarVariablesDocument/wwvars:Split">
      <xsl:variable name="VarVariablesSplit" select="." />

      <!-- Copy all variables -->
      <!--                    -->
      <xsl:copy-of select="$VarVariablesSplit/wwvars:Variable" />
     </xsl:for-each>
    </xsl:for-each>

    <!-- Preceding splits and this one -->
    <!--                               -->
    <xsl:for-each select="$VarVariablesGroup/wwvars:Document[@position = $VarDocumentPosition]">
     <xsl:variable name="VarVariablesDocument" select="." />

     <xsl:for-each select="$VarVariablesDocument/wwvars:Split[@position &lt;= $ParamSplit/@position]">
      <xsl:variable name="VarVariablesSplit" select="." />

      <!-- Copy all variables -->
      <!--                    -->
      <xsl:copy-of select="$VarVariablesSplit/wwvars:Variable" />
     </xsl:for-each>
    </xsl:for-each>
   </xsl:variable>
   <xsl:variable name="VarVariables" select="msxsl:node-set($VarVariablesAsXML)/wwvars:Variable" />

   <!-- Return last unique variable instance -->
   <!--                                      -->
   <xsl:call-template name="Variables-Filter-Last-Unique">
    <xsl:with-param name="ParamVariables" select="$VarVariables" />
   </xsl:call-template>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Variables-Filter-Last-Unique">
  <xsl:param name="ParamVariables" />

  <!-- Ensure variables are disconnected from their original document -->
  <!--                                                                -->
  <xsl:variable name="VarVariablesAsXML">
   <xsl:for-each select="$ParamVariables">
    <xsl:variable name="VarVariables" select="." />

    <xsl:copy-of select="$VarVariables" />
   </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="VarVariables" select="msxsl:node-set($VarVariablesAsXML)/wwvars:Variable" />

  <!-- Determine unique variable names -->
  <!--                                 -->
  <xsl:variable name="VarUniqueVariablesAsXML">
   <xsl:for-each select="$VarVariables">
    <xsl:variable name="VarVariable" select="." />

    <xsl:variable name="VarFirstVariableWithName" select="key('wwvars-variables-by-name', $VarVariable/@name)[1]" />
    <xsl:if test="count($VarFirstVariableWithName | $VarVariable) = 1">
     <xsl:copy-of select="$VarVariable" />
    </xsl:if>
   </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="VarUniqueVariables" select="msxsl:node-set($VarUniqueVariablesAsXML)/wwvars:Variable" />

  <!-- Return last unique variable instance -->
  <!--                                      -->
  <xsl:for-each select="$VarUniqueVariables">
   <xsl:variable name="VarUniqueVariable" select="." />

   <xsl:for-each select="$VarVariables[1]">
    <xsl:variable name="VarVariablesWithName" select="key('wwvars-variables-by-name', $VarUniqueVariable/@name)" />

    <xsl:for-each select="$VarVariablesWithName[last()]">
     <xsl:variable name="VarVariable" select="." />

     <xsl:copy-of select="$VarVariable" />
    </xsl:for-each>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Variables-Page-String-Replacements">
  <xsl:param name="ParamVariables" />

  <!-- Convert variables to simple string replacements -->
  <!--                                                 -->
  <xsl:for-each select="$ParamVariables">
   <xsl:variable name="VarVariable" select="." />

   <!-- Emit replacement -->
   <!--                  -->
   <wwpage:Replacement name="wwvars:{$VarVariable/@name}">
    <!-- Determine replacement value -->
    <!--                             -->
    <xsl:choose>
     <!-- Handle paragraphs -->
     <!--                   -->
     <xsl:when test="count($VarVariable/wwdoc:Paragraph) = 1">
      <xsl:apply-templates select="$VarVariable/wwdoc:Paragraph/wwdoc:Number/wwdoc:* | $VarVariable/wwdoc:Paragraph/wwdoc:TextRun/wwdoc:*" mode="wwmode:string-value" />
     </xsl:when>

     <!-- Handle text runs (character runs) -->
     <!--                                   -->
     <xsl:when test="count($VarVariable/wwdoc:TextRun) = 1">
      <xsl:apply-templates select="$VarVariable/wwdoc:TextRun/wwdoc:*" mode="wwmode:string-value" />
     </xsl:when>

     <!-- Handle markers -->
     <!--                -->
     <xsl:when test="count($VarVariable/wwdoc:Marker) = 1">
      <xsl:apply-templates select="$VarVariable/wwdoc:Marker/wwdoc:TextRun/wwdoc:*" mode="wwmode:string-value" />
     </xsl:when>

     <!-- Undefined -->
     <!--           -->
     <xsl:otherwise>
      <xsl:value-of select="''" />
     </xsl:otherwise>
    </xsl:choose>
   </wwpage:Replacement>
  </xsl:for-each>
 </xsl:template>


 <xsl:template match="wwdoc:LineBreak" mode="wwmode:string-value">
  <xsl:text> </xsl:text>
 </xsl:template>


 <xsl:template match="wwdoc:Text" mode="wwmode:string-value">
  <xsl:value-of select="@value" />
 </xsl:template>


 <xsl:template match="* | node() | text() | comment() | processing-instruction()" mode="wwmode:string-value">
  <!-- Ignore -->
  <!--        -->
 </xsl:template>
</xsl:stylesheet>
